/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class CommandUnloadChunk
implements ISubCommand {
    public static ISubCommand instance = new CommandUnloadChunk();
    Field chunksToUnload;

    @Override
    public String getCommandName() {
        return "unloadchunk";
    }

    @Override
    public int getPermissionLevel() {
        return 4;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        Set set;
        if (!(iCommandSender instanceof EntityPlayerMP)) {
            return;
        }
        if (this.chunksToUnload == null) {
            this.chunksToUnload = ReflectionHelper.findField(ChunkProviderServer.class, (String[])new String[]{"field_73248_b", "chunksToUnload"});
        }
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)iCommandSender;
        MovingObjectPosition movingObjectPosition = RayTracer.reTrace(entityPlayerMP.worldObj, (EntityPlayer)entityPlayerMP, 100.0);
        Chunk chunk = entityPlayerMP.worldObj.getChunkFromBlockCoords(movingObjectPosition.blockX, movingObjectPosition.blockZ);
        try {
            set = (Set)this.chunksToUnload.get(entityPlayerMP.getServerForPlayer().theChunkProviderServer);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Throwables.propagate((Throwable)illegalAccessException);
        }
        set.add(ChunkCoordIntPair.chunkXZ2Int((int)chunk.xPosition, (int)chunk.zPosition));
        CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.unloadchunk.success", chunk.xPosition, chunk.zPosition);
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        return null;
    }
}

